<?php
namespace model;

use \lib\Lang as Lang;

class Statistics extends \Pawn\Model
{
	// Migration
	public static function migration()
	{
		return false;
		
		return array
		(
			array('CREATE', array
			(
				'ip'		=>	'VARCHAR(15)',
				'route'		=>	'VARCHAR(255)',
				'agent'		=>	'VARCHAR(255)'
			)),
			array('REMOVE', array('ip', 'route', 'agent')),
			array('ADD', array
			(
				'hits'		=>	'INT UNSIGNED',
				'visitors'	=>	'INT UNSIGNED',
				'unique'	=>	'INT UNSIGNED'
			))
		);
	}
	
	// View
	public static function model_view($controller)
	{
		$days = array();
		$visitors = array();
		
		# Previous
		if($statistic = self::get('ORDER BY ts_create DESC LIMIT 1')->fetch())
		{
			$previous = $statistic->ts_create;
		} else
		{
			$previous = \Pawn::setting('setup');
		}
		
		# Raw
		if(time() - $previous >= 84600 && $file = @fopen(ROOT.'cache/statistics.php', 'r'))
		{
			
		}
		
		# Parsed
		$rows = \model\Statistics::get()->fetchAll();
		
		foreach($rows as $row)
		{
			$day = date('Y,n-1,j', $row->ts_create);
			
			if(!isset($days[$day]))
			{
				$days[$day] = array
				(
					'views'		=>	0,
					'visits'	=>	0,
					'new'		=>	0,
					'ts'		=>	$row->ts_create
				);
			}
			
			$days[$day]['views']++;
			
			if(!isset($visitors[$row->ip]))
			{
				$days[$day]['new']++;
				$days[$day]['visits']++;
			} elseif($visitors[$row->ip] != $day)
			{
				$days[$day]['visits']++;
			}
			
			$visitors[$row->ip] = $day;
		}
		
		return $controller->render('pawn/statistics.html', array
		(
			'heading'		=>	Lang::get('admin', 'Statistics', 'instances'),
			'about'			=>	Lang::get('admin', 'Statistics', 'about'),
			
			'days'			=>	$days,
			
			'navigation'	=>	$controller->navigation('Statistics')
		));
	}
}